/*
 * ConfigDialog.h
 *
 *  Created on: 04.05.2011
 *      Author: stefan.detter
 */

#ifndef CONFIGDIALOG_H_
#define CONFIGDIALOG_H_

#include <QTextEdit>
#include <QrfeReaderInterfaceGlobal>

class ConfigDialog
{
public:
	ConfigDialog();
	virtual ~ConfigDialog();

protected:
	virtual void setInfoEdit(QTextEdit* infoEdit);

	virtual void infoSet(const QString& text);
	virtual void infoSetProcessing(const QString& text);
	virtual void infoSetOK(const QString& text);
	virtual void infoSetError(const QString& text);
	virtual void infoAppend(const QString& text);

	virtual void handleError(QrfeGlobal::TMIResult result, const QString& text);
	virtual void clearInfo();
	virtual void showProcessing();
	virtual void showOK();
	virtual void showTagUnreachable();
	virtual void showWrongPassword();
	virtual void showMemoryOverrun();
	virtual void showMemoryLocked();
	virtual void showInsufficentPower();
	virtual void showNOK();

protected:
	QTextEdit* 		m_infoEdit;
};

#endif /* CONFIGDIALOG_H_ */
